/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.zookeeper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.camel.util.IOHelper;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedZookeeperServer {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedZookeeperServer.class);
    private final NIOServerCnxnFactory connectionFactory;
    private final ZooKeeperServer zkServer;
    private final Path zookeeperBaseDir;
    private final int port;

    public EmbeddedZookeeperServer() throws Exception {
        this(PortUtils.getAvailablePort(), Files.createTempDirectory("zktemp", new FileAttribute[0]));
    }

    public EmbeddedZookeeperServer(int port, Path baseDir) throws Exception {
        this.port = port;
        this.zookeeperBaseDir = baseDir;
        this.zkServer = new ZooKeeperServer();
        File dataDir = this.zookeeperBaseDir.resolve("log").toFile();
        File snapDir = this.zookeeperBaseDir.resolve("data").toFile();
        FileTxnSnapLog ftxn = new FileTxnSnapLog(dataDir, snapDir);
        this.zkServer.setTxnLogFactory(ftxn);
        this.zkServer.setTickTime(1000);
        this.connectionFactory = new NIOServerCnxnFactory(){

            protected void configureSaslLogin() throws IOException {
            }
        };
        this.connectionFactory.configure(new InetSocketAddress("localhost", port), 0);
    }

    public int getServerPort() {
        return this.port;
    }

    public String getConnection() {
        return "localhost:" + this.port;
    }

    public EmbeddedZookeeperServer startup(int timeout, TimeUnit unit) throws Exception {
        this.connectionFactory.startup(this.zkServer);
        if (timeout > 0) {
            EmbeddedZookeeperServer.waitForServerUp(this.getConnection(), unit.toMillis(timeout));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        try {
            this.connectionFactory.shutdown();
            this.connectionFactory.join();
            this.zkServer.shutdown();
            while (this.zkServer.isRunning()) {
                this.zkServer.shutdown();
                Thread.sleep(100L);
            }
        }
        finally {
            this.cleanZookeeperDir();
        }
    }

    public static boolean waitForServerUp(String hp, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                hp = hp.split(",")[0];
                String result = EmbeddedZookeeperServer.send4LetterWord(hp, "stat");
                if (result.startsWith("Zookeeper version:")) {
                    return true;
                }
            }
            catch (IOException e) {
                LOG.info("server {} not up {}", (Object)hp, (Object)e);
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String send4LetterWord(String hp, String cmd) throws IOException {
        int port;
        String[] split = hp.split(":");
        String host = split[0];
        try {
            port = Integer.parseInt(split[1]);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Problem parsing " + hp + e.toString());
        }
        Socket sock = new Socket(host, port);
        BufferedReader reader = null;
        try {
            String line;
            OutputStream outstream = sock.getOutputStream();
            outstream.write(cmd.getBytes());
            outstream.flush();
            reader = IOHelper.buffered((Reader)new InputStreamReader(sock.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            sock.close();
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void cleanZookeeperDir() throws Exception {
        Files.walkFileTree(this.zookeeperBaseDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exception) throws IOException {
                exception.printStackTrace();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exception) throws IOException {
                if (exception == null) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static final class PortUtils {
        PortUtils() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static int getAvailablePort() {
            int n;
            ServerSocket socket = new ServerSocket(0);
            try {
                n = socket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    socket.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot find available port: " + e.getMessage(), e);
                }
            }
            socket.close();
            return n;
        }
    }
}

