/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jgroups;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jgroups.JGroupsFilters;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class JGroupsIntegrationTest {
    String master;
    int nominationCount;
    String jgroupsEndpoint = String.format("jgroups:%s?enableViewMessages=true", UUID.randomUUID());
    CountDownLatch latch = new CountDownLatch(1);
    DefaultCamelContext camelcxt;

    @Deployment
    public static JavaArchive createdeployment() throws IOException {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jgroups-tests");
        return archive;
    }

    @Before
    public void setUp() throws Exception {
        this.camelcxt = new DefaultCamelContext();
        this.camelcxt.setName("firstNode");
        class JGroupsRouteBuilder
        extends RouteBuilder {
            JGroupsRouteBuilder() {
            }

            public void configure() throws Exception {
                this.from(JGroupsIntegrationTest.this.jgroupsEndpoint).filter(JGroupsFilters.dropNonCoordinatorViews()).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String camelContextName = exchange.getContext().getName();
                        if (!camelContextName.equals(JGroupsIntegrationTest.this.master)) {
                            JGroupsIntegrationTest.this.master = camelContextName;
                            System.out.println("ELECTED MASTER: " + JGroupsIntegrationTest.this.master);
                            ++JGroupsIntegrationTest.this.nominationCount;
                            JGroupsIntegrationTest.this.latch.countDown();
                        }
                    }
                });
            }
        }
        this.camelcxt.addRoutes((RoutesBuilder)new JGroupsRouteBuilder());
    }

    @Test
    public void testMasterElection() throws Exception {
        this.camelcxt.start();
        Assert.assertTrue((boolean)this.latch.await(3L, TimeUnit.SECONDS));
        this.latch = new CountDownLatch(1);
        String firstMaster = this.master;
        Assert.assertEquals((Object)this.camelcxt.getName(), (Object)firstMaster);
        this.camelcxt.stop();
    }
}

