/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jms;

import java.io.InputStream;
import javax.annotation.Resource;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.camel.Component;
import org.apache.camel.PollingConsumer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.spring.spi.SpringTransactionPolicy;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.test.integration.common.jms.JMSOperations;
import org.jboss.as.test.integration.common.jms.JMSOperationsProvider;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
@ServerSetup(value={JmsQueueSetup.class})
public class TransactedJMSIntegrationTest {
    @ArquillianResource
    InitialContext initialctx;
    @Resource(mappedName="java:/JmsXA")
    private ConnectionFactory connectionFactory;
    @Resource(mappedName="java:/TransactionManager")
    private TransactionManager transactionManager;
    @Resource(mappedName="java:/jboss/UserTransaction")
    private UserTransaction userTransaction;
    private JmsComponent jmsComponent;

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jms-tx-tests");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addManifestHeader("Dependencies", "org.jboss.as.controller-client");
                return builder.openStream();
            }
        });
        return archive;
    }

    @Before
    public void setUp() throws Exception {
        JtaTransactionManager jtaTransactionManager = new JtaTransactionManager(this.userTransaction, this.transactionManager);
        TransactionTemplate template = new TransactionTemplate((PlatformTransactionManager)jtaTransactionManager, (TransactionDefinition)new DefaultTransactionDefinition(0));
        SpringTransactionPolicy transactionPolicy = new SpringTransactionPolicy();
        transactionPolicy.setTransactionTemplate(template);
        transactionPolicy.setTransactionManager((PlatformTransactionManager)jtaTransactionManager);
        this.initialctx.bind("PROPAGATION_REQUIRED", (Object)transactionPolicy);
        this.initialctx.bind("transactionManager", (Object)jtaTransactionManager);
        this.jmsComponent = JmsComponent.jmsComponentTransacted((ConnectionFactory)this.connectionFactory, (PlatformTransactionManager)jtaTransactionManager);
    }

    @After
    public void tearDown() throws Exception {
        this.initialctx.unbind("PROPAGATION_REQUIRED");
        this.initialctx.unbind("transactionManager");
    }

    @Test
    public void testJMSTransactionToDLQ() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addComponent("jms", (Component)this.jmsComponent);
        camelctx.addRoutes(this.configureJmsRoutes());
        camelctx.start();
        PollingConsumer consumer = camelctx.getEndpoint("direct:dlq").createPollingConsumer();
        consumer.start();
        Connection connection = this.connectionFactory.createConnection();
        this.sendMessage(connection, JmsQueue.QUEUE_ONE.getJndiName(), "Hello Bob");
        String result = (String)consumer.receive().getIn().getBody(String.class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Hello Bob", (Object)result);
        connection.close();
        camelctx.stop();
    }

    @Test
    public void testJMSTransaction() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addComponent("jms", (Component)this.jmsComponent);
        camelctx.addRoutes(this.configureJmsRoutes());
        camelctx.start();
        PollingConsumer consumer = camelctx.getEndpoint("direct:success").createPollingConsumer();
        consumer.start();
        Connection connection = this.connectionFactory.createConnection();
        this.sendMessage(connection, JmsQueue.QUEUE_ONE.getJndiName(), "Hello Kermit");
        String result = (String)consumer.receive().getIn().getBody(String.class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        connection.close();
        camelctx.stop();
    }

    private RoutesBuilder configureJmsRoutes() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel(JmsQueue.DEAD_LETTER_QUEUE.getCamelEndpointUri()).useOriginalMessage().maximumRedeliveries(0).redeliveryDelay(1000L));
                this.from(JmsQueue.QUEUE_ONE.getCamelEndpointUri()).transacted("PROPAGATION_REQUIRED").to(JmsQueue.QUEUE_TWO.getCamelEndpointUri());
                ((ChoiceDefinition)this.from(JmsQueue.QUEUE_TWO.getCamelEndpointUri()).choice().when(this.body().contains((Object)"Bob")).throwException((Exception)new IllegalArgumentException("Invalid name"))).otherwise().to("direct:success");
                this.from(JmsQueue.DEAD_LETTER_QUEUE.getCamelEndpointUri()).to("direct:dlq");
            }
        };
    }

    private void sendMessage(Connection connection, String jndiName, String message) throws Exception {
        InitialContext initialctx = new InitialContext();
        Session session = connection.createSession(false, 1);
        Destination destination = (Destination)initialctx.lookup(jndiName);
        MessageProducer producer = session.createProducer(destination);
        TextMessage msg = session.createTextMessage(message);
        producer.send((Message)msg);
        connection.start();
    }

    private static enum JmsQueue {
        QUEUE_ONE("camel-jms-queue-one"),
        QUEUE_TWO("camel-jms-queue-two"),
        DEAD_LETTER_QUEUE("DLQ");

        private final String queueName;

        private JmsQueue(String queueName) {
            this.queueName = queueName;
        }

        public String getQueueName() {
            return this.queueName;
        }

        public String getJndiName() {
            return "java:/jms/queue/" + this.queueName;
        }

        public String getCamelEndpointUri() {
            return "jms:queue:" + this.queueName;
        }
    }

    static class JmsQueueSetup
    implements ServerSetupTask {
        private JMSOperations jmsAdminOperations;

        JmsQueueSetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            for (JmsQueue jmsQueue : JmsQueue.values()) {
                if (jmsQueue.equals((Object)JmsQueue.DEAD_LETTER_QUEUE)) continue;
                this.jmsAdminOperations = JMSOperationsProvider.getInstance((ManagementClient)managementClient);
                this.jmsAdminOperations.createJmsQueue(jmsQueue.getQueueName(), jmsQueue.getJndiName());
            }
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            if (this.jmsAdminOperations != null) {
                for (JmsQueue jmsQueue : JmsQueue.values()) {
                    if (jmsQueue.equals((Object)JmsQueue.DEAD_LETTER_QUEUE)) continue;
                    this.jmsAdminOperations.removeJmsQueue(jmsQueue.getQueueName());
                }
                this.jmsAdminOperations.close();
            }
        }
    }
}

