/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jmx;

import javax.management.monitor.MonitorNotification;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.DMRUtils;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
@ServerSetup(value={SystemContextSetupTask.class})
public class JMXIntegrationTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jmx-integration-tests");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMonitorMBeanAttribute() throws Exception {
        CamelContext context = this.contextRegistry.getCamelContext("jmx-context-1");
        Assert.assertNotNull((String)"Camel context jmx-context-1 was null", (Object)context);
        final String routeName = ((Route)context.getRoutes().get(0)).getId();
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("jmx:platform?format=raw&objectDomain=org.apache.camel&key.context=jmx-context-1&key.type=routes&key.name=\"" + routeName + "\"" + "&monitorType=counter&observedAttribute=ExchangesTotal&granularityPeriod=500").to("direct:end");
            }
        });
        camelctx.start();
        try {
            ConsumerTemplate consumer = camelctx.createConsumerTemplate();
            MonitorNotification notifcation = (MonitorNotification)consumer.receiveBody("direct:end", MonitorNotification.class);
            Assert.assertEquals((Object)"ExchangesTotal", (Object)notifcation.getObservedAttribute());
        }
        finally {
            camelctx.stop();
        }
    }

    static class SystemContextSetupTask
    implements ServerSetupTask {
        SystemContextSetupTask() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            String contextXml = "\t\t     <route>\n\t\t       <from uri=\"direct:start\"/>\n\t\t       <transform>\n\t\t         <simple>Hello #{body}</simple>\n\t\t       </transform>\n\t\t     </route>\n";
            ModelNode contextOpAdd = DMRUtils.createOpNode((String)"subsystem=camel/context=jmx-context-1/", (String)"add");
            contextOpAdd.get("value").set(contextXml);
            managementClient.getControllerClient().execute(DMRUtils.createCompositeNode((ModelNode[])new ModelNode[]{contextOpAdd}));
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            ModelNode contextOpAdd = DMRUtils.createOpNode((String)"subsystem=camel/context=jmx-context-1/", (String)"remove");
            managementClient.getControllerClient().execute(DMRUtils.createCompositeNode((ModelNode[])new ModelNode[]{contextOpAdd}));
        }
    }
}

