/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.json;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.json.subA.Employee;
import org.wildfly.camel.test.json.subA.Organization;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class JSONJacksonAnnotationsTest {
    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"json-jackson-annotations-test.jar");
        archive.addPackage(Employee.class.getPackage());
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJsonIgnore() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                JacksonDataFormat jacksonDataFormat = new JacksonDataFormat();
                jacksonDataFormat.setPrettyPrint(false);
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Organization organization = new Organization();
                        organization.setName("The Organization");
                        Employee employee = new Employee();
                        employee.setName("The Manager");
                        employee.setEmployeeNumber(12345);
                        employee.setOrganization(organization);
                        organization.setManager(employee);
                        exchange.getIn().setBody((Object)employee);
                    }
                })).marshal((DataFormat)jacksonDataFormat);
            }
        });
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            String result = (String)template.requestBody("direct:start", null, String.class);
            Assert.assertEquals((Object)"{\"name\":\"The Manager\"}", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

