/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.restlet;

import java.net.MalformedURLException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.cxf.rs.subA.GreetingService;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class RestletConsumerIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jaxrs-consumer-tests");
        archive.addClasses(new Class[]{GreetingService.class});
        return archive;
    }

    @Test
    public void testCxfRsConsumer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("restlet://" + RestletConsumerIntegrationTest.this.getEndpointAddress("/simple")).to("direct:end");
            }
        });
        try {
            camelctx.start();
            Assert.fail((String)"Expected RuntimeException to be thrown but it was not");
        }
        catch (RuntimeException ex) {
            String message = ex.getMessage();
            Assert.assertTrue((String)("Message equals: " + message), (boolean)message.contains("Restlet consumer endpoint not supported"));
        }
    }

    private String getEndpointAddress(String contextPath) throws MalformedURLException {
        return "http://localhost:8080" + contextPath + "/rest/greet/hello/Kermit";
    }
}

