/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.script;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.script.subA.CustomGroovyShellFactory;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class GroovyShellFactoryTest {
    private static final String GROOVY_SCRIPT = "groovy-script.grv";
    @Resource(mappedName="java:jboss/camel/context/spring-context")
    CamelContext camelctx;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"script-tests.jar");
        archive.addClasses(new Class[]{CustomGroovyShellFactory.class});
        archive.addAsResource("script/groovy-transform-camel-context.xml");
        archive.addAsResource("script/groovy-script.grv", GROOVY_SCRIPT);
        archive.addAsManifestResource((Asset)new StringAsset(""), "beans.xml");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroovy() throws Exception {
        CountDownProcessor proc = new CountDownProcessor(1);
        Consumer consumer = this.camelctx.getEndpoint("seda:end").createConsumer((Processor)proc);
        consumer.start();
        try {
            ProducerTemplate producer = this.camelctx.createProducerTemplate();
            producer.sendBodyAndHeader("direct:start", (Object)"10", "foo", (Object)"bar");
            producer.sendBodyAndHeader("direct:start", (Object)"2", "foo", (Object)"bar");
            Assert.assertTrue((String)"Message not processed by consumer", (boolean)proc.await(3L, TimeUnit.SECONDS));
            Assert.assertEquals((Object)"Hello 1010", (Object)proc.getExchange().getIn().getBody(String.class));
        }
        finally {
            consumer.stop();
        }
    }

    class CountDownProcessor
    implements Processor {
        private final CountDownLatch latch;
        private Exchange exchange;

        CountDownProcessor(int count) {
            this.latch = new CountDownLatch(count);
        }

        public synchronized void process(Exchange exchange) throws Exception {
            this.exchange = exchange;
            this.latch.countDown();
            System.out.println(exchange);
        }

        synchronized Exchange getExchange() {
            return this.exchange;
        }

        boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }
    }
}

