/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.switchyard;

import java.io.InputStream;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultClassResolver;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.switchyard.subA.JavaDSL;
import org.wildfly.camel.test.switchyard.subA.JavaDSLBuilder;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class CamelContextHooksTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"switchyard-camelctx-tests.jar");
        archive.addClasses(new Class[]{JavaDSL.class, JavaDSLBuilder.class});
        archive.addAsManifestResource("switchyard/switchyard.xml", "switchyard.xml");
        archive.addAsManifestResource("switchyard/route.xml", "route.xml");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addManifestHeader("Dependencies", "org.wildfly.extension.camel,org.apache.camel.core");
                return builder.openStream();
            }
        });
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCamelContextNotEnhanced() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform((Expression)this.body().prepend((Object)"Hello "));
            }
        });
        camelctx.start();
        try {
            Assert.assertNull((String)"Null ApplicationContextClassLoader", (Object)camelctx.getApplicationContextClassLoader());
            Assert.assertTrue((String)"Has DefaultClassResolver", (boolean)(camelctx.getClassResolver() instanceof DefaultClassResolver));
            Assert.assertNull((String)"Not in CamelContextRegistry", (Object)this.contextRegistry.getCamelContext(camelctx.getName()));
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

