/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.atom;

import org.apache.abdera.model.Entry;
import org.apache.camel.PollingConsumer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.atom.feed.AtomFeed;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class AtomIntegrationTest {
    @Deployment
    public static WebArchive createdeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"atom-test.war");
        archive.addAsWebInfResource((Asset)new StringAsset(""), "beans.xml");
        archive.addPackage(AtomFeed.class.getPackage());
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsumeAtomFeed() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("atom://http://localhost:8080/atom-test/atom/feed?splitEntries=true").to("direct:end");
            }
        });
        camelctx.start();
        try {
            PollingConsumer pollingConsumer = camelctx.getEndpoint("direct:end").createPollingConsumer();
            pollingConsumer.start();
            Entry result = (Entry)pollingConsumer.receive().getIn().getBody(Entry.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result.getTitle());
            Assert.assertEquals((Object)"Greeting Kermit", (Object)result.getContent());
        }
        finally {
            camelctx.stop();
        }
    }
}

