/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cdi;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.Container;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.cdi.subC.InjectedContextBean;
import org.wildfly.camel.test.cdi.subC.RouteBuilderA;
import org.wildfly.camel.test.cdi.subC.RouteBuilderB;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
@CamelAware
public class CDIContextCreationIntegrationTest {
    private static final String CDI_CONTEXT_A = "cdi-context-a.jar";
    private static final String CDI_CONTEXT_B = "cdi-context-b.jar";
    @ArquillianResource
    private Deployer deployer;
    @ArquillianResource
    private CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class);
    }

    @Deployment(name="cdi-context-a.jar", managed=false, testable=false)
    public static JavaArchive createCdiTestJar() {
        return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)CDI_CONTEXT_A)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addClasses(new Class[]{InjectedContextBean.class, RouteBuilderA.class});
    }

    @Deployment(name="cdi-context-b.jar", managed=false, testable=false)
    public static JavaArchive createOtherCdiTestJar() {
        return (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)CDI_CONTEXT_B)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addClasses(new Class[]{InjectedContextBean.class, RouteBuilderB.class});
    }

    @After
    public void tearDown() {
        Container.Instance.set(null);
    }

    @Test
    public void testCDIContextCreation() throws InterruptedException {
        FakeContainer container = new FakeContainer();
        Container.Instance.set((Container)container);
        Assert.assertEquals((long)0L, (long)container.getContextCount());
        Assert.assertEquals((long)0L, (long)this.contextRegistry.getCamelContexts().size());
        this.deployer.deploy(CDI_CONTEXT_A);
        Assert.assertEquals((long)1L, (long)container.getContextCount());
        Assert.assertEquals((long)1L, (long)this.contextRegistry.getCamelContexts().size());
        this.deployer.deploy(CDI_CONTEXT_B);
        Assert.assertEquals((long)2L, (long)container.getContextCount());
        Assert.assertEquals((long)2L, (long)this.contextRegistry.getCamelContexts().size());
        this.deployer.undeploy(CDI_CONTEXT_A);
        this.deployer.undeploy(CDI_CONTEXT_B);
        Assert.assertEquals((long)0L, (long)this.contextRegistry.getCamelContexts().size());
    }

    private static final class FakeContainer
    implements Container {
        private List<CamelContext> camelContextList = new ArrayList<CamelContext>();

        private FakeContainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void manage(CamelContext camelContext) {
            List<CamelContext> list = this.camelContextList;
            synchronized (list) {
                this.camelContextList.add(camelContext);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getContextCount() {
            List<CamelContext> list = this.camelContextList;
            synchronized (list) {
                return this.camelContextList.size();
            }
        }
    }
}

