/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cdi;

import java.util.Map;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.apache.camel.cdi.Uri;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.CamelContextHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.cdi.subA.Constants;
import org.wildfly.camel.test.cdi.subA.RoutesContextA;
import org.wildfly.camel.test.cdi.subA.RoutesContextB;
import org.wildfly.camel.test.cdi.subA.RoutesContextC;
import org.wildfly.camel.test.cdi.subA.RoutesContextD;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
@Ignore(value="[ENTESB-3167] Cannot define multiple CDI camel contexts with @ContextName")
public class CDIIntegrationTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;
    @Inject
    RoutesContextA routesA;
    @Inject
    RoutesContextB routesB;
    @Inject
    RoutesContextC routesC;
    @Inject
    RoutesContextD routesD;
    @Inject
    @Uri(value="seda:foo", context="contextD")
    ProducerTemplate producerD;

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-cdi-tests.jar");
        archive.addPackage(RoutesContextA.class.getPackage());
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return archive;
    }

    @Test
    public void checkContextsHaveCorrectEndpointsAndRoutes() throws Exception {
        CamelContext contextA = this.assertCamelContext("contextA");
        this.assertHasEndpoints(contextA, "seda://A.a", "mock://A.b");
        MockEndpoint mockEndpoint = this.routesA.b;
        mockEndpoint.expectedBodiesReceived(Constants.EXPECTED_BODIES_A);
        this.routesA.sendMessages();
        mockEndpoint.assertIsSatisfied();
        CamelContext contextB = this.assertCamelContext("contextB");
        this.assertHasEndpoints(contextB, "seda://B.a", "mock://B.b");
        MockEndpoint mockEndpointB = this.routesB.b;
        mockEndpointB.expectedBodiesReceived(Constants.EXPECTED_BODIES_B);
        this.routesB.sendMessages();
        mockEndpointB.assertIsSatisfied();
        CamelContext contextC = this.assertCamelContext("contextC");
        this.assertHasEndpoints(contextC, "seda://C.a", "mock://C.b");
        MockEndpoint mockEndpointC = this.routesC.b;
        mockEndpointC.expectedBodiesReceived(Constants.EXPECTED_BODIES_C);
        this.routesC.sendMessages();
        mockEndpointC.assertIsSatisfied();
        CamelContext contextD = this.assertCamelContext("contextD");
        this.assertHasEndpoints(contextD, "seda://D.a", "mock://D.b");
        MockEndpoint mockEndpointD = this.routesD.b;
        mockEndpointD.expectedBodiesReceived(Constants.EXPECTED_BODIES_D);
        this.routesD.sendMessages();
        mockEndpointD.assertIsSatisfied();
        CamelContext contextE = this.assertCamelContext("contextD");
        this.assertHasEndpoints(contextE, "seda://D.a", "mock://D.b");
        MockEndpoint mockDb = (MockEndpoint)CamelContextHelper.getMandatoryEndpoint((CamelContext)contextE, (String)"mock://D.b", MockEndpoint.class);
        mockDb.reset();
        mockDb.expectedBodiesReceived(Constants.EXPECTED_BODIES_D_A);
        for (Object body : Constants.EXPECTED_BODIES_D_A) {
            this.producerD.sendBody("seda:D.a", body);
        }
        mockDb.assertIsSatisfied();
    }

    private void assertHasEndpoints(CamelContext context, String ... uris) {
        Map endpointMap = context.getEndpointMap();
        for (String uri : uris) {
            Endpoint endpoint = (Endpoint)endpointMap.get(uri);
            Assert.assertNotNull((String)("CamelContext " + context + " does not have an Endpoint with URI " + uri + " but has " + endpointMap.keySet()), (Object)endpoint);
        }
    }

    private CamelContext assertCamelContext(String contextName) {
        CamelContext camelctx = this.contextRegistry.getCamelContext(contextName);
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        return camelctx;
    }
}

