/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cxf;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.cxf.ws.subA.Endpoint;
import org.wildfly.camel.test.cxf.ws.subA.EndpointImpl;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class CXFEndpointXmlConfigurationTest {
    private static final String SIMPLE_WAR = "simple.war";
    @ArquillianResource
    Deployer deployer;
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cxf-spring-context-tests");
        archive.addClasses(new Class[]{Endpoint.class});
        archive.addAsResource("cxf/spring/cxf-endpoint-camel-context.xml", "META-INF/jboss-camel-context.xml");
        return archive;
    }

    @Deployment(name="simple.war", managed=false, testable=false)
    public static Archive<?> getSimpleWar() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)SIMPLE_WAR);
        archive.addClasses(new Class[]{Endpoint.class, EndpointImpl.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCxfSpringContext() throws Exception {
        this.deployer.deploy(SIMPLE_WAR);
        try {
            CamelContext camelctx = this.contextRegistry.getCamelContext("cxf-context");
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            this.deployer.undeploy(SIMPLE_WAR);
        }
    }
}

