/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jpa;

import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.UserTransaction;
import org.apache.camel.CamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.jpa.subA.Account;
import org.wildfly.camel.test.jpa.subA.JpaRouteBuilder;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class TransactionalJpaIntegrationTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;
    @PersistenceContext
    EntityManager em;
    @Resource(mappedName="java:jboss/UserTransaction")
    private UserTransaction utx;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jpa-tests.jar");
        archive.addPackage(JpaRouteBuilder.class.getPackage());
        archive.addAsResource("jpa/persistence.xml", "META-INF/persistence.xml");
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return archive;
    }

    @Before
    public void setUp() throws Exception {
        this.utx.begin();
        this.em.joinTransaction();
        this.em.persist((Object)new Account(1, 750));
        this.em.persist((Object)new Account(2, 300));
        this.utx.commit();
        this.em.clear();
    }

    @After
    public void tearDown() throws Exception {
        this.utx.begin();
        this.em.joinTransaction();
        this.em.createQuery("delete from Account").executeUpdate();
        this.utx.commit();
    }

    @Test
    public void testJpaTransactionalRoute() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("jpa-cdi-context");
        Account accountA = (Account)this.em.getReference(Account.class, (Object)1);
        Account accountB = (Account)this.em.getReference(Account.class, (Object)2);
        Assert.assertEquals((long)750L, (long)accountA.getBalance());
        Assert.assertEquals((long)300L, (long)accountB.getBalance());
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("sourceAccountId", 1);
        params.put("targetAccountId", 2);
        params.put("amount", 250);
        camelctx.createProducerTemplate().sendBody("direct:start", params);
        accountA = (Account)this.em.getReference(Account.class, (Object)1);
        accountB = (Account)this.em.getReference(Account.class, (Object)2);
        Assert.assertEquals((long)500L, (long)accountA.getBalance());
        Assert.assertEquals((long)550L, (long)accountB.getBalance());
    }

    @Test
    public void testJpaTransactionalRouteRollback() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("jpa-cdi-context");
        Account accountA = (Account)this.em.getReference(Account.class, (Object)1);
        Account accountB = (Account)this.em.getReference(Account.class, (Object)2);
        Assert.assertEquals((long)750L, (long)accountA.getBalance());
        Assert.assertEquals((long)300L, (long)accountB.getBalance());
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("sourceAccountId", 1);
        params.put("targetAccountId", 2);
        params.put("amount", 550);
        camelctx.createProducerTemplate().sendBody("direct:start", params);
        accountA = (Account)this.em.getReference(Account.class, (Object)1);
        accountB = (Account)this.em.getReference(Account.class, (Object)2);
        Assert.assertEquals((long)750L, (long)accountA.getBalance());
        Assert.assertEquals((long)300L, (long)accountB.getBalance());
        String deadLetterDir = System.getProperty("jboss.server.data.dir") + "/deadletter/";
        Assert.assertTrue((boolean)new File(Paths.get(deadLetterDir, "deadLetters.xml").toUri()).exists());
    }
}

