/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.mail;

import java.io.File;
import javax.mail.Message;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mail.MailMessage;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.jvnet.mock_javamail.Mailbox;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class MailIntegrationTest {
    @Deployment
    public static WebArchive createdeployment() {
        File[] mailDependencies = ((MavenFormatStage)((MavenStrategyStage)Maven.configureResolverViaPlugin().resolve("org.jvnet.mock-javamail:mock-javamail")).withTransitivity()).asFile();
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"camel-test.war");
        archive.addAsLibraries(mailDependencies);
        return archive;
    }

    @Before
    public void before() {
        Mailbox.clearAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendEmail() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("smtp://localhost?from=bob@localhost&to=kermit@localhost&subject=Greetings");
                this.from("pop3://kermit@localhost?consumer.delay=1000").to("direct:email");
            }
        });
        camelctx.start();
        try {
            PollingConsumer pollingConsumer = camelctx.getEndpoint("direct:email").createPollingConsumer();
            pollingConsumer.start();
            ProducerTemplate producer = camelctx.createProducerTemplate();
            producer.sendBody("direct:start", (Object)"Hello Kermit");
            MailMessage mailMessage = (MailMessage)pollingConsumer.receive().getIn().getBody(MailMessage.class);
            Message message = mailMessage.getMessage();
            Assert.assertEquals((Object)"bob@localhost", (Object)message.getFrom()[0].toString());
            Assert.assertEquals((Object)"Greetings", (Object)message.getSubject());
            Assert.assertEquals((Object)"Hello Kermit", (Object)message.getContent());
        }
        finally {
            camelctx.stop();
        }
    }
}

