/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.script;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.script.ScriptBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.utils.IOUtils;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class ScriptIntegrationTest {
    private static final String BEANSHELL_SCRIPT = "beanshell-script.bsh";
    private static final String GROOVY_SCRIPT = "groovy-script.grv";
    private static final String JAVA_SCRIPT = "java-script.js";
    private static final String PYTHON_SCRIPT = "python-script.py";
    private static final String RUBY_SCRIPT = "ruby-script.rb";

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"script-tests");
        archive.addAsResource("script/beanshell-script.bsh", BEANSHELL_SCRIPT);
        archive.addAsResource("script/groovy-script.grv", GROOVY_SCRIPT);
        archive.addAsResource("script/java-script.js", JAVA_SCRIPT);
        archive.addAsResource("script/python-script.py", PYTHON_SCRIPT);
        archive.addAsResource("script/ruby-script.rb", RUBY_SCRIPT);
        return archive;
    }

    @Test
    public void testBeanshell() throws Exception {
        this.scriptProcessing("beanshell", BEANSHELL_SCRIPT);
    }

    @Test
    public void testPhyton() throws Exception {
        this.scriptProcessing("python", PYTHON_SCRIPT);
    }

    @Test
    public void testRuby() throws Exception {
        this.scriptProcessing("ruby", RUBY_SCRIPT);
    }

    @Test
    public void testGroovy() throws Exception {
        this.scriptProcessing("groovy", GROOVY_SCRIPT);
    }

    @Test
    public void testJavaScrip() throws Exception {
        this.scriptProcessing("javaScript", JAVA_SCRIPT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scriptProcessing(final String type, final String resource) throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").process((Processor)ScriptBuilder.script((String)type, (String)ScriptIntegrationTest.this.scriptSource(resource)));
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    private String scriptSource(String resource) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        InputStream input = this.getClass().getResourceAsStream("/" + resource);
        IOUtils.copyStream((InputStream)input, (OutputStream)baos);
        return new String(baos.toByteArray());
    }
}

