/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.tagsoup;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class TidyMarkupIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"tagsoup-tests");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal().tidyMarkup();
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = ((String)producer.requestBody("direct:start", (Object)"<body><a href=foo></body>", String.class)).trim();
            Assert.assertTrue((String)("Starts with html: " + result), (boolean)result.startsWith("<html "));
            Assert.assertTrue((String)("Contains link quotes: " + result), (boolean)result.contains("<a href=\"foo\""));
            Assert.assertTrue((String)("Contains end link: " + result), (boolean)result.contains("</a>"));
            Assert.assertTrue((String)("Ends with html: " + result), (boolean)result.endsWith("</html>"));
        }
        finally {
            camelctx.stop();
        }
    }
}

