/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.xmlsecurity;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import javax.naming.InitialContext;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.xmlsecurity.api.KeyAccessor;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.w3c.dom.Node;
import org.wildfly.camel.test.common.EnvironmentUtils;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class XmlSecurityIntegrationTest {
    private static String XML_PAYLOAD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root xmlns=\"http://test/test\"><test>Hello Kermit</test></root>";
    private KeyPair keyPair;
    @ArquillianResource
    private InitialContext initialContext;

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"camel-test.war");
        archive.addClasses(new Class[]{EnvironmentUtils.class});
        return archive;
    }

    @Before
    public void setUp() throws Exception {
        this.keyPair = this.setUpKeys();
        this.initialContext.bind("accessor", (Object)XmlSecurityIntegrationTest.getKeyAccessor(this.keyPair.getPrivate()));
        this.initialContext.bind("selector", (Object)KeySelector.singletonKeySelector(this.keyPair.getPublic()));
    }

    @After
    public void tearDown() throws Exception {
        this.initialContext.unbind("accessor");
        this.initialContext.unbind("selector");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXmlSigning() throws Exception {
        Assume.assumeFalse((String)"[ENTESB-6650] XmlSecurityIntegrationTest fails on AIX", (boolean)EnvironmentUtils.isAIX());
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("xmlsecurity:sign://enveloping?keyAccessor=#accessor&schemaResourceUri=");
            }
        });
        try {
            camelctx.start();
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String signedXml = (String)producer.requestBody("direct:start", (Object)XML_PAYLOAD, String.class);
            Assert.assertTrue((boolean)signedXml.contains("ds:SignatureValue"));
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXmlVerifySigning() throws Exception {
        Assume.assumeFalse((String)"[ENTESB-6650] XmlSecurityIntegrationTest fails on AIX", (boolean)EnvironmentUtils.isAIX());
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("xmlsecurity:sign://enveloping?keyAccessor=#accessor&schemaResourceUri=")).to("xmlsecurity:verify://enveloping?keySelector=#selector");
            }
        });
        try {
            camelctx.start();
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String verifiedXml = (String)producer.requestBody("direct:start", (Object)XML_PAYLOAD, String.class);
            Assert.assertEquals((Object)XML_PAYLOAD, (Object)verifiedXml);
        }
        finally {
            camelctx.stop();
        }
    }

    private KeyPair setUpKeys() {
        KeyPairGenerator keyGen;
        try {
            keyGen = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        keyGen.initialize(1024, new SecureRandom());
        return keyGen.generateKeyPair();
    }

    private static KeyAccessor getKeyAccessor(final PrivateKey privateKey) {
        KeyAccessor accessor = new KeyAccessor(){

            public KeySelector getKeySelector(Message message) throws Exception {
                return KeySelector.singletonKeySelector(privateKey);
            }

            public KeyInfo getKeyInfo(Message mess, Node messageBody, KeyInfoFactory keyInfoFactory) throws Exception {
                return null;
            }
        };
        return accessor;
    }
}

