/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cassandra;

import java.util.List;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.cassandraunit.CassandraCQLUnit;
import org.cassandraunit.dataset.CQLDataSet;
import org.cassandraunit.dataset.cql.ClassPathCQLDataSet;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
@ServerSetup(value={CassandraServerSetup.class})
public class CassandraIntegrationTest {
    static final String HOST = "127.0.0.1";
    static final String KEYSPACE = "camel_ks";
    static final String CQL = "select login, first_name, last_name from camel_user";

    @Deployment
    public static JavaArchive createdeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cassandra-tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConsumeAll() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("cql://localhost/camel_ks?cql=select login, first_name, last_name from camel_user").to("seda:end");
            }
        });
        camelctx.start();
        try {
            ConsumerTemplate consumer = camelctx.createConsumerTemplate();
            List result = (List)consumer.receiveBody("seda:end", 3000L, List.class);
            Assert.assertNotNull((String)"Result not null", (Object)result);
            Assert.assertEquals((String)"Two records selected", (long)2L, (long)result.size());
        }
        finally {
            camelctx.stop();
        }
    }

    static class CassandraServerSetup
    implements ServerSetupTask {
        CassandraServerSetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            EmbeddedCassandraServerHelper.startEmbeddedCassandra((String)"/camel-cassandra.yaml", (String)"target/camel-cassandra", (long)30000L);
            new LoadableCassandraCQLUnit((CQLDataSet)new ClassPathCQLDataSet("cassandra/BasicDataSet.cql", CassandraIntegrationTest.KEYSPACE), "/camel-cassandra.yaml").setup();
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            EmbeddedCassandraServerHelper.cleanEmbeddedCassandra();
        }

        static class LoadableCassandraCQLUnit
        extends CassandraCQLUnit {
            LoadableCassandraCQLUnit(CQLDataSet dataSet, String configFile) {
                super(dataSet, configFile);
            }

            void setup() {
                super.load();
            }
        }
    }
}

