/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.dozer;

import java.util.Arrays;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.dozer.DozerBeanMapperConfiguration;
import org.apache.camel.converter.dozer.DozerTypeConverterLoader;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.dozer.subA.CustomerA;
import org.wildfly.camel.test.dozer.subA.CustomerB;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class DozerIntegrationTest {
    private static final String DOZER_MAPPINGS_XML = "dozer-mappings.xml";

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-dozer-tests");
        archive.addClasses(new Class[]{CustomerA.class, CustomerB.class});
        archive.addAsResource("dozer/dozer-mappings.xml", DOZER_MAPPINGS_XML);
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeanMapping() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").convertBodyTo(CustomerB.class);
            }
        });
        DozerBeanMapperConfiguration mconfig = new DozerBeanMapperConfiguration();
        mconfig.setMappingFiles(Arrays.asList(DOZER_MAPPINGS_XML));
        new DozerTypeConverterLoader((CamelContext)camelctx, mconfig);
        CustomerA customerA = new CustomerA("Peter", "Post", "Street", "12345");
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            CustomerB result = (CustomerB)producer.requestBody("direct:start", (Object)customerA, CustomerB.class);
            Assert.assertEquals((Object)customerA.getFirstName(), (Object)result.getFirstName());
            Assert.assertEquals((Object)customerA.getLastName(), (Object)result.getLastName());
            Assert.assertEquals((Object)customerA.getStreet(), (Object)result.getAddress().getStreet());
            Assert.assertEquals((Object)customerA.getZip(), (Object)result.getAddress().getZip());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshalJson() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal().json(JsonLibrary.XStream, CustomerA.class);
            }
        });
        String input = "{'" + CustomerA.class.getName() + "':{'firstName':'John','lastName':'Doe','street':'Street','zip':1234}}";
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            CustomerA customer = (CustomerA)producer.requestBody("direct:start", (Object)input, CustomerA.class);
            Assert.assertEquals((Object)"John", (Object)customer.getFirstName());
            Assert.assertEquals((Object)"Doe", (Object)customer.getLastName());
            Assert.assertEquals((Object)"Street", (Object)customer.getStreet());
            Assert.assertEquals((Object)"1234", (Object)customer.getZip());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshalJson() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal().json(JsonLibrary.XStream);
            }
        });
        String expected = "{'" + CustomerB.class.getName() + "':{'firstName':'John','lastName':'Doe','address':{'street':'Street','zip':1234}}}";
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)new CustomerB("John", "Doe", new CustomerB.Address("Street", "1234")), String.class);
            Assert.assertEquals((Object)expected.replace('\'', '\"'), (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

