/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.flatpack;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dataformat.flatpack.FlatpackDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class FlatpackIntegrationTest {
    private static final String FLATPACK_MAPPING_XML = "flatpack-mapping.xml";
    private static final String FLATPACK_INPUT_TXT = "people-fixed-length.txt";

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"flatpack-dataformat-tests");
        archive.addAsResource("flatpack/flatpack-mapping.xml", FLATPACK_MAPPING_XML);
        archive.addAsResource("flatpack/people-fixed-length.txt", FLATPACK_INPUT_TXT);
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshal() throws Exception {
        final FlatpackDataFormat format = new FlatpackDataFormat();
        format.setDefinition(FLATPACK_MAPPING_XML);
        format.setFixed(true);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal((DataFormat)format);
            }
        });
        InputStream input = this.getClass().getClassLoader().getResourceAsStream(FLATPACK_INPUT_TXT);
        Assert.assertNotNull((String)"Input not null", (Object)input);
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            List result = (List)producer.requestBody("direct:start", (Object)input, List.class);
            Assert.assertEquals((String)("Expected size 4: " + result), (long)4L, (long)result.size());
            Assert.assertEquals((Object)"JOHN", ((Map)result.get(0)).get("FIRSTNAME"));
            Assert.assertEquals((Object)"JIMMY", ((Map)result.get(1)).get("FIRSTNAME"));
            Assert.assertEquals((Object)"JANE", ((Map)result.get(2)).get("FIRSTNAME"));
            Assert.assertEquals((Object)"FRED", ((Map)result.get(3)).get("FIRSTNAME"));
        }
        finally {
            camelctx.stop();
        }
    }
}

