/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.ftp;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.ftpserver.ConnectionConfigFactory;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.filesystem.nativefs.NativeFileSystemFactory;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.ClearTextPasswordEncryptor;
import org.apache.ftpserver.usermanager.PasswordEncryptor;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.apache.ftpserver.usermanager.impl.WriteRequest;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.utils.TestUtils;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class FtpIntegrationTest {
    private static final String FILE_BASEDIR = "basedir.txt";
    private static final Path FTP_ROOT_DIR = Paths.get(System.getProperty("jboss.server.data.dir") + "/ftp", new String[0]);
    private static final Path USERS_FILE = Paths.get(System.getProperty("jboss.server.config.dir") + "/users.properties", new String[0]);
    private static final int PORT = TestUtils.getAvailablePort();
    private FtpServer ftpServer;

    @Deployment
    public static WebArchive createdeployment() throws IOException {
        File[] libraryDependencies = ((MavenFormatStage)((MavenStrategyStage)Maven.configureResolverViaPlugin().resolve("org.apache.ftpserver:ftpserver-core")).withTransitivity()).asFile();
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"camel-ftp-tests.war");
        archive.addAsResource((Asset)new StringAsset(System.getProperty("basedir")), FILE_BASEDIR);
        archive.addClasses(new Class[]{TestUtils.class});
        archive.addAsLibraries(libraryDependencies);
        return archive;
    }

    @Before
    public void startFtpServer() throws Exception {
        this.recursiveDelete(this.resolvePath(FTP_ROOT_DIR).toFile());
        File usersFile = USERS_FILE.toFile();
        usersFile.createNewFile();
        NativeFileSystemFactory fsf = new NativeFileSystemFactory();
        fsf.setCreateHome(true);
        PropertiesUserManagerFactory pumf = new PropertiesUserManagerFactory();
        pumf.setAdminName("admin");
        pumf.setPasswordEncryptor((PasswordEncryptor)new ClearTextPasswordEncryptor());
        pumf.setFile(usersFile);
        UserManager userMgr = pumf.createUserManager();
        BaseUser user = new BaseUser();
        user.setName("admin");
        user.setPassword("admin");
        user.setHomeDirectory(FTP_ROOT_DIR.toString());
        ArrayList<WritePermission> authorities = new ArrayList<WritePermission>();
        WritePermission writePermission = new WritePermission();
        writePermission.authorize((AuthorizationRequest)new WriteRequest());
        authorities.add(writePermission);
        user.setAuthorities(authorities);
        userMgr.save((User)user);
        ListenerFactory factory1 = new ListenerFactory();
        factory1.setPort(PORT);
        FtpServerFactory serverFactory = new FtpServerFactory();
        serverFactory.setUserManager(userMgr);
        serverFactory.setFileSystem((FileSystemFactory)fsf);
        serverFactory.setConnectionConfig(new ConnectionConfigFactory().createConnectionConfig());
        serverFactory.addListener("default", factory1.createListener());
        FtpServerFactory factory = serverFactory;
        this.ftpServer = factory.createServer();
        this.ftpServer.start();
    }

    @After
    public void stopFtpServer() throws Exception {
        if (this.ftpServer != null) {
            try {
                this.ftpServer.stop();
                this.ftpServer = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendFile() throws Exception {
        File testFile = this.resolvePath(FTP_ROOT_DIR).resolve("foo/test.txt").toFile();
        DefaultCamelContext camelctx = new DefaultCamelContext();
        try {
            Endpoint endpoint = camelctx.getEndpoint("ftp://localhost:" + PORT + "/foo?username=admin&password=admin");
            Assert.assertFalse((boolean)testFile.exists());
            camelctx.createProducerTemplate().sendBodyAndHeader(endpoint, (Object)"Hello", "CamelFileName", (Object)"test.txt");
            Assert.assertTrue((boolean)testFile.exists());
        }
        finally {
            camelctx.stop();
        }
    }

    @Test
    public void testComponentLoads() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        try {
            Endpoint endpoint = camelctx.getEndpoint("ftp://localhost/foo");
            Assert.assertNotNull((Object)endpoint);
            Assert.assertEquals((Object)endpoint.getClass().getName(), (Object)"org.apache.camel.component.file.remote.FtpEndpoint");
        }
        finally {
            camelctx.stop();
        }
    }

    private void recursiveDelete(File file) {
        if (file.exists()) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File f : files) {
                    this.recursiveDelete(f);
                }
            }
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path resolvePath(Path other) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/basedir.txt")));){
            Path path = Paths.get(reader.readLine(), new String[0]).resolve(other);
            return path;
        }
    }
}

