/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.handler;

import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.gravia.runtime.ServiceLocator;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.handler.subA.CamelActivationBean;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.ContextCreateHandlerRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class ContextCreateHandlerRegistryIntegrationTest {
    private static final String CAMEL_TEST_JAR = "camel-test.jar";
    @ArquillianResource
    private Deployer deployer;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"context-create-handler-tests.jar");
    }

    @Deployment(testable=false, managed=false, name="camel-test.jar")
    public static JavaArchive createCamelDeployment() {
        return (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)CAMEL_TEST_JAR)).addClass(CamelActivationBean.class);
    }

    @Test
    public void testHandlerRegistry() throws Exception {
        ContextCreateHandlerRegistry handlerRegistry = (ContextCreateHandlerRegistry)ServiceLocator.getRequiredService(ContextCreateHandlerRegistry.class);
        ModuleLoader moduleLoader = Module.getCallerModuleLoader();
        this.deployer.deploy(CAMEL_TEST_JAR);
        Module module = moduleLoader.loadModule(ModuleIdentifier.create((String)"deployment.camel-test.jar"));
        ModuleClassLoader classLoader = module.getClassLoader();
        Assert.assertTrue((boolean)handlerRegistry.containsKey((ClassLoader)classLoader));
        this.deployer.undeploy(CAMEL_TEST_JAR);
        Assert.assertFalse((String)("Expected registry to not contain key: " + classLoader), (boolean)handlerRegistry.containsKey((ClassLoader)classLoader));
    }
}

