/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jasypt;

import java.io.IOException;
import org.apache.camel.Component;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jasypt.JasyptPropertiesParser;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class JasyptIntegrationTest {
    @Deployment
    public static JavaArchive createdeployment() throws IOException {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jasypt-tests");
        archive.addAsResource("jasypt/password.properties", "password.properties");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPasswordDecryption() throws Exception {
        JasyptPropertiesParser jasypt = new JasyptPropertiesParser();
        jasypt.setPassword("secret");
        PropertiesComponent pc = new PropertiesComponent();
        pc.setLocation("classpath:password.properties");
        pc.setPropertiesParser((PropertiesParser)jasypt);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addComponent("properties", (Component)pc);
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").transform().simple("Hi ${body} the decrypted password is: ${properties:cool.password}");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"John", String.class);
            Assert.assertEquals((Object)"Hi John the decrypted password is: tiger", (Object)result.trim());
        }
        finally {
            camelctx.stop();
        }
    }
}

