/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jaxb;

import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ModelHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class JAXBInitalizationTest {
    @Deployment
    public static JavaArchive deployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jaxb-initialization-tests");
    }

    @Test
    public void testJaxbDumpModelAsXML() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("route-1").to("log:test");
            }
        });
        camelctx.start();
        try {
            String xml = ModelHelper.dumpModelAsXml((CamelContext)camelctx, (NamedNode)camelctx.getRouteDefinition("route-1"));
            Assert.assertTrue((boolean)xml.contains("log:test"));
        }
        finally {
            camelctx.stop();
        }
    }
}

