/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.olingo2;

import java.util.List;
import org.apache.camel.Component;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.olingo2.Olingo2Component;
import org.apache.camel.component.olingo2.Olingo2Configuration;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.olingo2.subA.Olingo2TestServlet;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class Olingo2IntegrationTest {
    private static final String OLINGO_SERVICE_URI = "http://localhost:8080/olingo-server/MyODataSample.svc/";

    @Deployment(testable=false, order=1, name="olingo-server.war")
    public static WebArchive createOlingoServerDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"olingo-server.war");
        archive.addPackage(Olingo2TestServlet.class.getPackage());
        archive.setManifest(() -> {
            ManifestBuilder builder = new ManifestBuilder();
            builder.addManifestHeader("Dependencies", "org.apache.cxf.ext,org.apache.olingo");
            return builder.openStream();
        });
        return archive;
    }

    @Deployment(order=2)
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-olingo2-tests");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOlingo2Read() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        Olingo2Configuration configuration = new Olingo2Configuration();
        configuration.setServiceUri(OLINGO_SERVICE_URI);
        Olingo2Component component = new Olingo2Component();
        component.setConfiguration(configuration);
        camelctx.addComponent("olingo2", (Component)component);
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("olingo2://read/Cars");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate template = camelctx.createProducerTemplate();
            ODataFeed carEntries = (ODataFeed)template.requestBody("direct:start", null, ODataFeed.class);
            Assert.assertNotNull((Object)carEntries);
            List cars = carEntries.getEntries();
            Assert.assertFalse((boolean)cars.isEmpty());
        }
        finally {
            camelctx.stop();
        }
    }
}

