/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.pdf;

import java.io.File;
import java.nio.file.Paths;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class PDFIntegrationTest {
    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"came-pdf-tests");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreate() throws Exception {
        final String datadir = System.getProperty("jboss.server.data.dir") + "/came-pdf-tests";
        Assert.assertNotNull((String)"Directory name not nul", (Object)datadir);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("pdf:create")).to("file:" + datadir + "?fileName=pdftest.pdf");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            producer.requestBody("direct:start", (Object)"Hello World");
            File outfile = Paths.get(datadir, "pdftest.pdf").toFile();
            Assert.assertTrue((String)("File existes: " + outfile), (boolean)outfile.exists());
        }
        finally {
            camelctx.stop();
        }
    }
}

