/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.rest;

import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.http.HttpRequest;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class RestDslMultipleVerbsIntegrationTest {
    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-rest-dsl-verbs");
        archive.addClasses(new Class[]{HttpRequest.class});
        return archive;
    }

    @Test
    public void testRestDsl() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().component("undertow").contextPath("camel/rest").host("localhost").port(8080);
                this.rest("/hello").get("/{name}").to("direct:get").post("/{name}").to("direct:post").put("/{name}").to("direct:put");
                this.from("direct:get").transform((Expression)this.simple("GET ${header.name}"));
                this.from("direct:post").transform((Expression)this.simple("POST ${header.name}"));
                this.from("direct:put").transform((Expression)this.simple("PUT ${header.name}"));
            }
        });
        camelctx.start();
        try {
            HttpRequest.HttpResponse result = HttpRequest.get((String)"http://localhost:8080/camel/rest/hello/Kermit").getResponse();
            Assert.assertEquals((Object)"GET Kermit", (Object)result.getBody());
            result = HttpRequest.post((String)"http://localhost:8080/camel/rest/hello/Kermit").getResponse();
            Assert.assertEquals((Object)"POST Kermit", (Object)result.getBody());
            result = HttpRequest.put((String)"http://localhost:8080/camel/rest/hello/Kermit").getResponse();
            Assert.assertEquals((Object)"PUT Kermit", (Object)result.getBody());
        }
        finally {
            camelctx.stop();
        }
    }
}

