/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.script;

import javax.annotation.Resource;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.script.subA.CustomGroovyShellFactory;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class GroovyShellFactoryTest {
    @Resource(name="java:jboss/camel/context/spring-context")
    CamelContext camelctx;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"script-tests.jar");
        archive.addPackage(CustomGroovyShellFactory.class.getPackage());
        archive.addAsResource("script/groovy-transform-camel-context.xml");
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return archive;
    }

    @Test
    public void testGroovy() throws Exception {
        ProducerTemplate producer = this.camelctx.createProducerTemplate();
        String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }

    @Test
    public void testGroovyWithHeader() throws Exception {
        ProducerTemplate producer = this.camelctx.createProducerTemplate();
        String result = (String)producer.requestBodyAndHeader("direct:start", (Object)"Kermit", "locale", (Object)"es", String.class);
        Assert.assertEquals((Object)"Hola Kermit", (Object)result);
    }
}

