/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.spring;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.spring.subA.ScannedRouteBuilder;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class SpringPackageScanWarTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static WebArchive createdeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"package-scan.war");
        archive.addAsWebInfResource("spring/package-scan-camel-context.xml");
        archive.addClasses(new Class[]{ScannedRouteBuilder.class});
        return archive;
    }

    @Test
    public void testTransform1() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("packageScan");
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        ProducerTemplate producer = camelctx.createProducerTemplate();
        String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }
}

