/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.converter;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.CustomConverter;
import org.wildfly.camel.test.common.types.Customer;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class CustomConverterTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"converter-tests");
        archive.addClasses(new Class[]{Customer.class, CustomConverter.class});
        archive.addAsServiceProvider("org/apache/camel/TypeConverter", new String[]{CustomConverter.class.getPackage().getName()});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").convertBodyTo(Map.class);
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Map result = (Map)producer.requestBody("direct:start", (Object)new Customer("John", "Doe"), Map.class);
            Assert.assertEquals((Object)"{firstName=John, lastName=Doe}", (Object)result.toString());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshal() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").convertBodyTo(Customer.class);
            }
        });
        LinkedHashMap<String, String> input = new LinkedHashMap<String, String>();
        input.put("firstName", "John");
        input.put("lastName", "Doe");
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Customer result = (Customer)producer.requestBody("direct:start", input, Customer.class);
            Assert.assertEquals((Object)"John", (Object)result.getFirstName());
            Assert.assertEquals((Object)"Doe", (Object)result.getLastName());
        }
        finally {
            camelctx.stop();
        }
    }
}

