/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.crypto;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class CryptoComponentIntegrationTest {
    private static final String ALIAS = "bob";
    private static final String KEYSTORE = "ks.keystore";
    private static final String KEYSTORE_PASSWORD = "letmein";
    private static final String PAYLOAD = "Dear Bob, Rest assured it's me, signed Kermit";
    @ArquillianResource
    private InitialContext initialContext;

    @Before
    public void setUp() throws Exception {
        KeyStore keystore = this.loadKeystore();
        Certificate cert = keystore.getCertificate(ALIAS);
        KeyStoreParameters keystoreParameters = new KeyStoreParameters();
        keystoreParameters.setPassword(KEYSTORE_PASSWORD);
        keystoreParameters.setResource("./ks.keystore");
        this.initialContext.bind("signatureParams", (Object)keystoreParameters);
        this.initialContext.bind("keystore", (Object)keystore);
        this.initialContext.bind("myPublicKey", (Object)cert.getPublicKey());
        this.initialContext.bind("myCert", (Object)cert);
        this.initialContext.bind("myPrivateKey", (Object)keystore.getKey(ALIAS, KEYSTORE_PASSWORD.toCharArray()));
    }

    @After
    public void tearDown() throws NamingException {
        this.initialContext.unbind("signatureParams");
        this.initialContext.unbind("keystore");
        this.initialContext.unbind("myPublicKey");
        this.initialContext.unbind("myCert");
        this.initialContext.unbind("myPrivateKey");
    }

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"crypto-tests");
        archive.addAsResource("crypto/ks.keystore", KEYSTORE);
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicSignatureRoute() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:sign").to("crypto:sign://basic?privateKey=#myPrivateKey")).to("direct:verify");
                ((RouteDefinition)this.from("direct:verify").to("crypto:verify://basic?publicKey=#myPublicKey")).to("mock:result");
            }
        });
        camelctx.start();
        try {
            camelctx.createProducerTemplate().sendBody("direct:sign", (Object)PAYLOAD);
            MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:result", MockEndpoint.class);
            Exchange e = (Exchange)mockEndpoint.getExchanges().get(0);
            Message result = e == null ? null : (e.hasOut() ? e.getOut() : e.getIn());
            Assert.assertNull((Object)result.getHeader("CamelDigitalSignature"));
        }
        finally {
            camelctx.stop();
        }
    }

    private KeyStore loadKeystore() throws Exception {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream in = this.getClass().getResourceAsStream("/ks.keystore");
        keystore.load(in, KEYSTORE_PASSWORD.toCharArray());
        return keystore;
    }
}

