/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cxf.rs;

import java.net.MalformedURLException;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.cxf.jaxrs.CxfRsComponent;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.cxf.rs.subA.GreetingService;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class CXFRSConsumerIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jaxrs-consumer-tests");
        archive.addClasses(new Class[]{GreetingService.class});
        return archive;
    }

    @Test
    public void testCxfRsConsumer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        CxfRsComponent component = new CxfRsComponent();
        Bus defaultBus = BusFactory.getDefaultBus((boolean)true);
        String uri = "cxfrs://" + this.getEndpointAddress("/simple");
        final CxfRsEndpoint cxfRsEndpoint = new CxfRsEndpoint(uri, (Component)component);
        cxfRsEndpoint.setCamelContext((CamelContext)camelctx);
        cxfRsEndpoint.setBus(defaultBus);
        cxfRsEndpoint.setDefaultBus(true);
        cxfRsEndpoint.setResourceClasses(new Class[]{GreetingService.class});
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from((Endpoint)cxfRsEndpoint).to("direct:end");
            }
        });
        try {
            camelctx.start();
            Assert.fail((String)"Expected RuntimeCamelException to be thrown but it was not");
        }
        catch (RuntimeException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)("Message equals: " + message), (boolean)message.equals("CXF consumer endpoint not supported"));
        }
    }

    private String getEndpointAddress(String contextPath) throws MalformedURLException {
        return "http://localhost:8080" + contextPath + "/rest/greet/hello/Kermit";
    }
}

