/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cxf.ws;

import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.Endpoint;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class CXFWSConsumerIntegrationTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cxf-ws-consumer-tests");
        archive.addClasses(new Class[]{Endpoint.class});
        return archive;
    }

    @Test
    public void testCxfConsumer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        final String uri = "cxf:/webservices/?serviceClass=" + Endpoint.class.getName();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from(uri).to("direct:end");
            }
        });
        try {
            camelctx.start();
            Assert.fail((String)"Expected RuntimeCamelException to be thrown but it was not");
        }
        catch (RuntimeException e) {
            String message = e.getMessage();
            Assert.assertTrue((String)("Message equals: " + message), (boolean)message.equals("CXF consumer endpoint not supported"));
        }
    }
}

