/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.dozer;

import java.util.Arrays;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.converter.dozer.DozerBeanMapperConfiguration;
import org.apache.camel.converter.dozer.DozerTypeConverterLoader;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.dozer.subA.CustomerA;
import org.wildfly.camel.test.dozer.subA.CustomerB;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class DozerIntegrationTest {
    private static final String DOZER_MAPPINGS_XML = "dozer-mappings.xml";

    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-dozer-tests");
        archive.addClasses(new Class[]{CustomerA.class, CustomerB.class});
        archive.addAsResource("dozer/dozer-mappings.xml", DOZER_MAPPINGS_XML);
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeanMapping() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").convertBodyTo(CustomerB.class);
            }
        });
        DozerBeanMapperConfiguration mconfig = new DozerBeanMapperConfiguration();
        mconfig.setMappingFiles(Arrays.asList(DOZER_MAPPINGS_XML));
        new DozerTypeConverterLoader((CamelContext)camelctx, mconfig);
        CustomerA customerA = new CustomerA("Peter", "Post", "SomeStreet", "12345");
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            CustomerB result = (CustomerB)producer.requestBody("direct:start", (Object)customerA, CustomerB.class);
            Assert.assertEquals((Object)customerA.getFirstName(), (Object)result.getFirstName());
            Assert.assertEquals((Object)customerA.getLastName(), (Object)result.getLastName());
            Assert.assertEquals((Object)customerA.getStreet(), (Object)result.getAddress().getStreet());
            Assert.assertEquals((Object)customerA.getZip(), (Object)result.getAddress().getZip());
        }
        finally {
            camelctx.stop();
        }
    }
}

