/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.file;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Paths;
import org.apache.camel.Expression;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class FileIntegrationTest {
    @Deployment
    public static JavaArchive createdeployment() throws IOException {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-file-tests");
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileEndpoint() throws Exception {
        final String datadir = System.getProperty("jboss.server.data.dir");
        Assert.assertNotNull((String)"Directory name not nul", (Object)datadir);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.body().prepend((Object)"Hello "))).to("file:" + datadir + "?fileName=camel-file.txt");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
        BufferedReader br = new BufferedReader(new FileReader(Paths.get(datadir, "camel-file.txt").toFile()));
        Assert.assertEquals((Object)"Hello Kermit", (Object)br.readLine());
        br.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileIdempotentConsumer() throws Exception {
        String datadir = System.getProperty("jboss.server.data.dir");
        Assert.assertNotNull((String)"Directory name not nul", (Object)datadir);
        final String fileEndpointUri = "file://" + datadir;
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from(fileEndpointUri + "?noop=true&idempotent=true&delay=10").to("mock:result");
            }
        });
        camelctx.start();
        try {
            MockEndpoint mockEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:result", MockEndpoint.class);
            mockEndpoint.expectedMessageCount(1);
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.sendBodyAndHeader(fileEndpointUri, (Object)"Testing idempotency", "CamelFileName", (Object)"idempotent-test.txt");
            Thread.sleep(300L);
            mockEndpoint.assertIsSatisfied();
        }
        finally {
            camelctx.stop();
        }
    }
}

