/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jms;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetup;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.utils.JMSUtils;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
@ServerSetup(value={JmsQueueSetup.class})
public class JMSIntegrationTest {
    static final String QUEUE_NAME = "camel-jms-queue";
    static final String QUEUE_JNDI_NAME = "java:/camel-jms-queue";
    @ArquillianResource
    InitialContext initialctx;

    @Deployment
    public static JavaArchive createdeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jms-tests");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageConsumerRoute() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("jms:queue:camel-jms-queue?connectionFactory=ConnectionFactory").transform((Expression)this.body().prepend((Object)"Hello "))).to("direct:end");
            }
        });
        camelctx.start();
        PollingConsumer consumer = camelctx.getEndpoint("direct:end").createPollingConsumer();
        consumer.start();
        try {
            ConnectionFactory cfactory = (ConnectionFactory)this.initialctx.lookup("java:/ConnectionFactory");
            try (Connection connection = cfactory.createConnection();){
                this.sendMessage(connection, QUEUE_JNDI_NAME, "Kermit");
                String result = (String)consumer.receive().getIn().getBody(String.class);
                Assert.assertEquals((Object)"Hello Kermit", (Object)result);
            }
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageConsumerRouteWithClientAck() throws Exception {
        final ArrayList result = new ArrayList();
        final CountDownLatch latch = new CountDownLatch(3);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("jms:queue:camel-jms-queue?connectionFactory=ConnectionFactory&acknowledgementModeName=CLIENT_ACKNOWLEDGE").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        JmsMessage in = (JmsMessage)exchange.getIn();
                        Session session = in.getJmsSession();
                        TextMessage message = (TextMessage)in.getJmsMessage();
                        long count = latch.getCount();
                        try {
                            result.add(message.getText() + " " + (4L - count));
                            if (count != 3L) {
                                if (count == 2L) {
                                    session.recover();
                                } else {
                                    message.acknowledge();
                                }
                            }
                        }
                        catch (JMSException ex) {
                            result.add(ex.getMessage());
                        }
                        latch.countDown();
                    }
                })).transform((Expression)this.body().prepend((Object)"Hello "))).to("direct:end");
            }
        });
        camelctx.start();
        PollingConsumer consumer = camelctx.getEndpoint("direct:end").createPollingConsumer();
        consumer.start();
        try {
            ConnectionFactory cfactory = (ConnectionFactory)this.initialctx.lookup("java:/ConnectionFactory");
            Connection connection = cfactory.createConnection();
            Session session = connection.createSession(false, 2);
            connection.start();
            Destination destination = (Destination)this.initialctx.lookup(QUEUE_JNDI_NAME);
            MessageProducer producer = session.createProducer(destination);
            try {
                producer.send((Message)session.createTextMessage("Kermit"));
                producer.send((Message)session.createTextMessage("Piggy"));
                Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
                Assert.assertEquals((String)"Four messages", (long)3L, (long)result.size());
                Assert.assertEquals((Object)"Kermit 1", result.get(0));
                Assert.assertEquals((Object)"Piggy 2", result.get(1));
                Assert.assertEquals((Object)"Piggy 3", result.get(2));
            }
            finally {
                connection.close();
            }
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageProviderRoute() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.body().prepend((Object)"Hello "))).to("jms:queue:camel-jms-queue?connectionFactory=ConnectionFactory");
            }
        });
        final ArrayList result = new ArrayList();
        final CountDownLatch latch = new CountDownLatch(1);
        camelctx.start();
        try {
            ConnectionFactory cfactory = (ConnectionFactory)this.initialctx.lookup("java:/ConnectionFactory");
            try (Connection connection = cfactory.createConnection();){
                this.receiveMessage(connection, QUEUE_JNDI_NAME, new MessageListener(){

                    public void onMessage(Message message) {
                        TextMessage text = (TextMessage)message;
                        try {
                            result.add(text.getText());
                        }
                        catch (JMSException ex) {
                            result.add(ex.getMessage());
                        }
                        latch.countDown();
                    }
                });
                ProducerTemplate producer = camelctx.createProducerTemplate();
                producer.asyncSendBody("direct:start", (Object)"Kermit");
                Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
                Assert.assertEquals((String)"One message", (long)1L, (long)result.size());
                Assert.assertEquals((Object)"Hello Kermit", result.get(0));
            }
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMessageProviderRouteWithClientAck() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").transform((Expression)this.body().prepend((Object)"Hello "))).to("jms:queue:camel-jms-queue?connectionFactory=ConnectionFactory");
            }
        });
        final ArrayList result = new ArrayList();
        final CountDownLatch latch = new CountDownLatch(4);
        camelctx.start();
        try {
            ConnectionFactory cfactory = (ConnectionFactory)this.initialctx.lookup("java:/ConnectionFactory");
            Connection connection = cfactory.createConnection();
            final Session session = connection.createSession(false, 2);
            Destination destination = (Destination)this.initialctx.lookup(QUEUE_JNDI_NAME);
            MessageConsumer consumer = session.createConsumer(destination);
            consumer.setMessageListener(new MessageListener(){

                public synchronized void onMessage(Message message) {
                    TextMessage text = (TextMessage)message;
                    long count = latch.getCount();
                    try {
                        result.add(text.getText() + " " + (5L - count));
                        if (count != 4L) {
                            if (count == 3L) {
                                session.recover();
                            } else {
                                message.acknowledge();
                            }
                        }
                    }
                    catch (JMSException ex) {
                        result.add(ex.getMessage());
                    }
                    latch.countDown();
                }
            });
            connection.start();
            try {
                ProducerTemplate producer = camelctx.createProducerTemplate();
                producer.asyncSendBody("direct:start", (Object)"Message");
                producer.asyncSendBody("direct:start", (Object)"Message");
                Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
                Assert.assertEquals((String)"Four messages", (long)4L, (long)result.size());
                Assert.assertEquals((Object)"Hello Message 1", result.get(0));
                Assert.assertEquals((Object)"Hello Message 2", result.get(1));
                Assert.assertEquals((Object)"Hello Message 3", result.get(2));
                Assert.assertEquals((Object)"Hello Message 4", result.get(3));
            }
            finally {
                connection.close();
            }
        }
        finally {
            camelctx.stop();
        }
    }

    private void sendMessage(Connection connection, String jndiName, String message) throws Exception {
        Session session = connection.createSession(false, 1);
        Destination destination = (Destination)this.initialctx.lookup(jndiName);
        MessageProducer producer = session.createProducer(destination);
        TextMessage msg = session.createTextMessage(message);
        producer.send((Message)msg);
        connection.start();
    }

    private Session receiveMessage(Connection connection, String jndiName, MessageListener listener) throws Exception {
        Session session = connection.createSession(false, 1);
        Destination destination = (Destination)this.initialctx.lookup(jndiName);
        MessageConsumer consumer = session.createConsumer(destination);
        consumer.setMessageListener(listener);
        connection.start();
        return session;
    }

    static class JmsQueueSetup
    implements ServerSetupTask {
        JmsQueueSetup() {
        }

        public void setup(ManagementClient managementClient, String containerId) throws Exception {
            JMSUtils.createJmsQueue((String)JMSIntegrationTest.QUEUE_NAME, (String)JMSIntegrationTest.QUEUE_JNDI_NAME, (ModelControllerClient)managementClient.getControllerClient());
        }

        public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
            JMSUtils.removeJmsQueue((String)JMSIntegrationTest.QUEUE_NAME, (ModelControllerClient)managementClient.getControllerClient());
        }
    }
}

