/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.jpa;

import javax.annotation.Resource;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.UserTransaction;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.jpa.subA.Account;
import org.wildfly.camel.test.jpa.subA.Accounting;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class ContainerManagedTransactionIntegrationTest {
    @PersistenceContext
    EntityManager em;
    @Resource(mappedName="java:jboss/UserTransaction")
    private UserTransaction utx;
    @Inject
    Accounting accounting;

    @Before
    public void setUp() throws Exception {
        this.utx.begin();
        this.em.persist((Object)new Account(1, 750));
        this.em.persist((Object)new Account(2, 300));
        this.em.persist((Object)new Account(3, 0));
        this.utx.commit();
    }

    @After
    public void tearDown() throws Exception {
        this.utx.begin();
        this.em.createQuery("delete from Account").executeUpdate();
        this.utx.commit();
    }

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"container-tx-tests.jar");
        archive.addClasses(new Class[]{Accounting.class, Account.class});
        archive.addAsResource("jpa/persistence.xml", "META-INF/persistence.xml");
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return archive;
    }

    @Test
    public void testGoodTransfer() throws Exception {
        this.accounting.transfer(250);
        Account accountA = (Account)this.em.getReference(Account.class, (Object)1);
        Account accountB = (Account)this.em.getReference(Account.class, (Object)2);
        Account accountC = (Account)this.em.getReference(Account.class, (Object)3);
        Assert.assertEquals((long)500L, (long)accountA.getBalance());
        Assert.assertEquals((long)550L, (long)accountB.getBalance());
        Assert.assertEquals((long)500L, (long)accountC.getBalance());
    }

    @Test
    public void testBadTransfer() throws Exception {
        this.accounting.transfer(1250);
        Account accountA = (Account)this.em.getReference(Account.class, (Object)1);
        Account accountB = (Account)this.em.getReference(Account.class, (Object)2);
        Account accountC = (Account)this.em.getReference(Account.class, (Object)3);
        Assert.assertEquals((long)750L, (long)accountA.getBalance());
        Assert.assertEquals((long)300L, (long)accountB.getBalance());
        Assert.assertEquals((long)0L, (long)accountC.getBalance());
    }

    @Test
    public void testGoodCamelTransfer() throws Exception {
        this.accounting.transferCamel(250);
        Account accountA = (Account)this.em.getReference(Account.class, (Object)1);
        Account accountB = (Account)this.em.getReference(Account.class, (Object)2);
        Account accountC = (Account)this.em.getReference(Account.class, (Object)3);
        Assert.assertEquals((long)500L, (long)accountA.getBalance());
        Assert.assertEquals((long)550L, (long)accountB.getBalance());
        Assert.assertEquals((long)500L, (long)accountC.getBalance());
    }

    @Test
    public void testBadCamelTransfer() throws Exception {
        this.accounting.transferCamel(1250);
        Account accountA = (Account)this.em.getReference(Account.class, (Object)1);
        Account accountB = (Account)this.em.getReference(Account.class, (Object)2);
        Account accountC = (Account)this.em.getReference(Account.class, (Object)3);
        Assert.assertEquals((long)750L, (long)accountA.getBalance());
        Assert.assertEquals((long)300L, (long)accountB.getBalance());
        Assert.assertEquals((long)0L, (long)accountC.getBalance());
    }
}

