/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.json;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jackson.JacksonDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.dataformat.JsonLibrary;
import org.apache.camel.spi.DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.Customer;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class JSONDataFormatTest {
    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"json-dataformat-tests");
        archive.addClasses(new Class[]{Customer.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshalJson() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal().json();
            }
        });
        String expected = "{'" + Customer.class.getName() + "':{'firstName':'John','lastName':'Doe'}}";
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)new Customer("John", "Doe"), String.class);
            Assert.assertEquals((Object)expected.replace('\'', '\"'), (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshalJackson() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal().json(JsonLibrary.Jackson);
            }
        });
        String expected = "{'firstName':'John','lastName':'Doe'}";
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)new Customer("John", "Doe"), String.class);
            Assert.assertEquals((Object)expected.replace('\'', '\"'), (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshalJson() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal().json(JsonLibrary.XStream, Customer.class);
            }
        });
        String input = "{'" + Customer.class.getName() + "':{'firstName':'John','lastName':'Doe'}}";
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Customer customer = (Customer)producer.requestBody("direct:start", (Object)input, Customer.class);
            Assert.assertEquals((Object)"John", (Object)customer.getFirstName());
            Assert.assertEquals((Object)"Doe", (Object)customer.getLastName());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshalJackson() throws Exception {
        final JacksonDataFormat format = new JacksonDataFormat(Customer.class);
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal((DataFormat)format);
            }
        });
        String input = "{'firstName':'John','lastName':'Doe'}";
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Customer customer = (Customer)producer.requestBody("direct:start", (Object)input.replace('\'', '\"'), Customer.class);
            Assert.assertEquals((Object)"John", (Object)customer.getFirstName());
            Assert.assertEquals((Object)"Doe", (Object)customer.getLastName());
        }
        finally {
            camelctx.stop();
        }
    }
}

