/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.kafka;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.consumer.Consumer;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import kafka.javaapi.consumer.ConsumerConnector;
import kafka.javaapi.producer.Producer;
import kafka.producer.KeyedMessage;
import kafka.producer.ProducerConfig;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.kafka.KafkaConstants;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.camel.test.common.zookeeper.EmbeddedZookeeperServer;
import org.wildfly.camel.test.kafka.EmbeddedKafkaCluster;
import org.wildfly.camel.test.kafka.subA.SimpleKafkaPartitioner;
import org.wildfly.camel.test.kafka.subA.SimpleKafkaSerializer;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class KafkaIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaIntegrationTest.class);
    private static final String TEST_TOPIC_NAME = "test";
    private static final int KAFKA_PORT = 9092;
    private static final int ZOOKEEPER_PORT = 2181;
    private static EmbeddedZookeeperServer zkServer;
    private static EmbeddedKafkaCluster kafkaCluster;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"kafka-integration-tests.jar");
        archive.addClasses(new Class[]{EmbeddedZookeeperServer.class, EmbeddedKafkaCluster.class, KafkaConstants.class});
        return archive;
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        ArrayList<Integer> kafkaPorts = new ArrayList<Integer>();
        kafkaPorts.add(9092);
        zkServer = new EmbeddedZookeeperServer(2181, Paths.get("target", "zookeper"));
        kafkaCluster = new EmbeddedKafkaCluster(zkServer.getConnection(), new Properties(), kafkaPorts);
        zkServer.startup(1, TimeUnit.SECONDS);
        kafkaCluster.startup();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (kafkaCluster != null) {
            kafkaCluster.shutdown();
        }
        if (zkServer != null) {
            zkServer.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKafkaProducer() throws Exception {
        String zkhost = "&zookeeperHost=localhost";
        String zkport = "&zookeeperPort=2181";
        String serializer = "&serializerClass=kafka.serializer.StringEncoder";
        final String epuri = "kafka:localhost:9092?topic=test&groupId=group1" + zkhost + zkport + serializer;
        DefaultCamelContext camelctx = new DefaultCamelContext();
        ConsumerConnector kafkaMessageConsumer = null;
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to(epuri);
            }
        });
        camelctx.start();
        try {
            CountDownLatch latch = new CountDownLatch(5);
            kafkaMessageConsumer = this.createKafkaMessageConsumer(latch);
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("kafka.PARTITION_KEY", "1");
            ProducerTemplate producerTemplate = camelctx.createProducerTemplate();
            for (int i = 0; i < 5; ++i) {
                producerTemplate.sendBodyAndHeaders("direct:start", (Object)("Camel Kafka test message " + i), headerMap);
            }
            boolean result = latch.await(5L, TimeUnit.SECONDS);
            Assert.assertTrue((String)("Expected 5 messages. Not received: " + latch.getCount()), (boolean)result);
        }
        finally {
            camelctx.stop();
            if (kafkaMessageConsumer != null) {
                kafkaMessageConsumer.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKafkaConsumer() throws Exception {
        String zkhost = "&zookeeperHost=localhost";
        String zkport = "&zookeeperPort=2181";
        final String epuri = "kafka:localhost:9092?topic=test&groupId=group1&autoOffsetReset=smallest" + zkhost + zkport;
        final CountDownLatch latch = new CountDownLatch(5);
        Producer<String, String> producer = this.createKafkaMessageProducer();
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from(epuri).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        LOG.info("Consumed message {}", exchange.getIn().getBody());
                        latch.countDown();
                    }
                });
            }
        });
        camelctx.start();
        try {
            for (int i = 0; i < 5; ++i) {
                KeyedMessage data = new KeyedMessage(TEST_TOPIC_NAME, (Object)"1", (Object)("Camel Kafka test message " + i));
                producer.send(data);
            }
            boolean result = latch.await(10L, TimeUnit.SECONDS);
            Assert.assertTrue((String)("Expected to consume 5 messages but consumed " + latch.getCount()), (boolean)result);
        }
        finally {
            producer.close();
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="[KAFKA-2295] Dynamically loaded classes (encoders, etc.) may not be found by Kafka Producer")
    public void testCustomKafkaPartitionerLoads() throws Exception {
        String zkhost = "&zookeeperHost=localhost";
        String zkport = "&zookeeperPort=2181";
        String partitioner = "&partitionerClass=" + SimpleKafkaPartitioner.class.getName();
        final String epuri = "kafka:localhost:9092?topic=test&groupId=group1" + zkhost + zkport + partitioner;
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("testCustomPartitioner").to(epuri);
            }
        });
        camelctx.start();
        try {
            Route route = camelctx.getRoute("testCustomPartitioner");
            Assert.assertTrue((boolean)route.getRouteContext().isRouteAdded());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="[KAFKA-2295] Dynamically loaded classes (encoders, etc.) may not be found by Kafka Producer")
    public void testCustomKafkaSerializerLoads() throws Exception {
        String zkhost = "&zookeeperHost=localhost";
        String zkport = "&zookeeperPort=2181";
        String serializer = "&serializerClass=" + SimpleKafkaSerializer.class.getName();
        final String epuri = "kafka:localhost:9092?topic=test&groupId=group1" + zkhost + zkport + serializer;
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("testCustomSerializer").to(epuri);
            }
        });
        camelctx.start();
        try {
            Route route = camelctx.getRoute("testCustomSerializer");
            Assert.assertTrue((boolean)route.getRouteContext().isRouteAdded());
        }
        finally {
            camelctx.stop();
        }
    }

    private ConsumerConnector createKafkaMessageConsumer(CountDownLatch messagesLatch) {
        Properties consumerProps = new Properties();
        consumerProps.put("zookeeper.connect", "localhost:2181");
        consumerProps.put("group.id", "group1");
        consumerProps.put("zookeeper.session.timeout.ms", "6000");
        consumerProps.put("zookeeper.connectiontimeout.ms", "12000");
        consumerProps.put("zookeeper.sync.time.ms", "200");
        consumerProps.put("auto.commit.interval.ms", "1000");
        consumerProps.put("auto.offset.reset", "smallest");
        ConsumerConnector kafkaConsumer = Consumer.createJavaConsumerConnector((ConsumerConfig)new ConsumerConfig(consumerProps));
        HashMap<String, Integer> topicCountMap = new HashMap<String, Integer>();
        topicCountMap.put(TEST_TOPIC_NAME, 5);
        Map consumerMap = kafkaConsumer.createMessageStreams(topicCountMap);
        ExecutorService executor = Executors.newFixedThreadPool(5);
        for (KafkaStream stream : (List)consumerMap.get(TEST_TOPIC_NAME)) {
            executor.submit(new KakfaTopicConsumer((KafkaStream<byte[], byte[]>)stream, messagesLatch));
        }
        return kafkaConsumer;
    }

    private Producer<String, String> createKafkaMessageProducer() {
        Properties properties = new Properties();
        properties.put("metadata.broker.list", "localhost:9092");
        properties.put("serializer.class", "kafka.serializer.StringEncoder");
        properties.put("request.required.acks", "1");
        ProducerConfig config = new ProducerConfig(properties);
        return new Producer(config);
    }

    private static class KakfaTopicConsumer
    implements Runnable {
        private KafkaStream<byte[], byte[]> stream;
        private CountDownLatch latch;

        public KakfaTopicConsumer(KafkaStream<byte[], byte[]> stream, CountDownLatch latch) {
            this.stream = stream;
            this.latch = latch;
        }

        @Override
        public void run() {
            ConsumerIterator it = this.stream.iterator();
            while (it.hasNext()) {
                String msg = new String((byte[])it.next().message());
                LOG.info("Received message: {}", (Object)msg);
                this.latch.countDown();
            }
        }
    }
}

