/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import java.util.SortedMap;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.spi.Registry;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class MetricsIntegrationTest {
    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"came-metrics-tests.jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRouteMetrics() throws Exception {
        SimpleRegistry registry = new SimpleRegistry();
        MetricRegistry metricRegistry = new MetricRegistry();
        registry.put((Object)"metricRegistry", (Object)metricRegistry);
        DefaultCamelContext camelctx = new DefaultCamelContext((Registry)registry);
        try {
            camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:start").to("metrics:counter:simple.counter?increment=5");
                }
            });
            camelctx.start();
            ProducerTemplate template = camelctx.createProducerTemplate();
            template.requestBody("direct:start", (Object)"fake body");
            SortedMap counters = metricRegistry.getCounters();
            Counter counter = null;
            for (String counterName : counters.keySet()) {
                if (!counterName.equals("simple.counter")) continue;
                counter = (Counter)counters.get(counterName);
                break;
            }
            Assert.assertNotNull((String)"Counter simple.counter was null", counter);
            Assert.assertEquals((long)5L, (long)counter.getCount());
        }
        finally {
            camelctx.stop();
        }
    }
}

