/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.rest;

import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.http.HttpRequest;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class RestDslIntegrationTest {
    @Deployment
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"camel.war");
        archive.addAsWebInfResource("rest/web.xml", "web.xml");
        archive.addClasses(new Class[]{HttpRequest.class});
        return archive;
    }

    @Test
    public void testRestDsl() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().component("servlet").contextPath("camel/rest").port(8080);
                this.rest("/hello").get("/{name}").to("direct:hello");
                this.from("direct:hello").transform((Expression)this.simple("Hello ${header.name}"));
            }
        });
        camelctx.start();
        try {
            HttpRequest.HttpResponse result = HttpRequest.get((String)"http://localhost:8080/camel/rest/hello/Kermit").getResponse();
            Assert.assertEquals((Object)"Hello Kermit", (Object)result.getBody());
        }
        finally {
            camelctx.stop();
        }
    }
}

