/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.spring;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.extension.camel.CamelContextRegistry;

@RunWith(value=Arquillian.class)
public class SpringJdbcNamespaceTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-jdbc-tests");
        archive.addAsResource("spring/jdbc-namespace-camel-context.xml");
        archive.addAsResource("spring/sql/db-schema.sql", "db-schema.sql");
        archive.addAsResource("spring/sql/db-data.sql", "db-data.sql");
        return archive;
    }

    @Test
    public void testSpringJdbcNamespace() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("spring-jdbc");
        Assert.assertNotNull((Object)camelctx);
        MockEndpoint resultEndpoint = (MockEndpoint)camelctx.getEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(1);
        MockEndpoint.assertWait((long)5L, (TimeUnit)TimeUnit.SECONDS, (MockEndpoint[])new MockEndpoint[]{resultEndpoint});
        resultEndpoint.assertIsSatisfied();
        String result = (String)((Exchange)resultEndpoint.getExchanges().get(0)).getIn().getBody(String.class);
        Assert.assertEquals((Object)"Hello kermit", (Object)result);
    }
}

