/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.undertow;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.http.HttpRequest;
import org.wildfly.camel.test.http4.subA.MyServlet;

@RunWith(value=Arquillian.class)
public class UndertowConsumerIntegrationTest {
    @ArquillianResource
    ManagementClient managementClient;

    @Deployment
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"undertow-consumer.war");
        archive.addClasses(new Class[]{MyServlet.class, HttpRequest.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHttpConsumer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("undertow:http://localhost/myapp/serviceA").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Message in = exchange.getIn();
                        in.setBody((Object)("Hello " + in.getHeader("name")));
                    }
                })).to("seda:endA");
                ((RouteDefinition)this.from("undertow:http://localhost/myapp/serviceB").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        Message in = exchange.getIn();
                        in.setBody((Object)("Hello " + in.getHeader("name")));
                    }
                })).to("seda:endB");
            }
        });
        camelctx.start();
        try {
            CountDownProcessor procA = new CountDownProcessor(1);
            Consumer consumerA = camelctx.getEndpoint("seda:endA").createConsumer((Processor)procA);
            CountDownProcessor procB = new CountDownProcessor(1);
            Consumer consumerB = camelctx.getEndpoint("seda:endB").createConsumer((Processor)procB);
            HttpRequest.HttpResponse response = HttpRequest.get((String)"http://localhost:8080/myapp/serviceA?name=Kermit").getResponse();
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            response = HttpRequest.get((String)"http://localhost:8080/myapp/serviceB?name=Piggy").getResponse();
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            consumerA.start();
            try {
                Assert.assertTrue((String)"Message not processed by consumer", (boolean)procA.await(3L, TimeUnit.SECONDS));
                Assert.assertEquals((Object)"Hello Kermit", (Object)procA.getExchange().getIn().getBody(String.class));
            }
            finally {
                consumerA.stop();
            }
            consumerB.start();
            try {
                Assert.assertTrue((String)"Message not processed by consumer", (boolean)procB.await(3L, TimeUnit.SECONDS));
                Assert.assertEquals((Object)"Hello Piggy", (Object)procB.getExchange().getIn().getBody(String.class));
            }
            finally {
                consumerB.stop();
            }
        }
        finally {
            camelctx.stop();
        }
    }

    class CountDownProcessor
    implements Processor {
        private final CountDownLatch latch;
        private Exchange exchange;

        CountDownProcessor(int count) {
            this.latch = new CountDownLatch(count);
        }

        public synchronized void process(Exchange exchange) throws Exception {
            this.exchange = exchange;
            this.latch.countDown();
        }

        synchronized Exchange getExchange() {
            return this.exchange;
        }

        boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            return this.latch.await(timeout, unit);
        }
    }
}

