/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.io.InputStream;
import java.util.Deque;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.gravia.runtime.ServiceLocator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.http.HttpRequest;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowService;

@CamelAware
@RunWith(value=Arquillian.class)
public class UndertowHandlerTest {
    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"undertow-handler-test");
        archive.addClasses(new Class[]{HttpRequest.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                ManifestBuilder builder = new ManifestBuilder();
                builder.addManifestHeader("Dependencies", "org.wildfly.extension.undertow,io.undertow.core");
                return builder.openStream();
            }
        });
        return archive;
    }

    @Test
    public void testHttpEndpoint() throws Exception {
        ServiceContainer container = (ServiceContainer)ServiceLocator.getRequiredService(ServiceContainer.class);
        ServiceName hostServiceName = UndertowService.virtualHostName((String)"default-server", (String)"default-host");
        Host host = (Host)container.getRequiredService(hostServiceName).getValue();
        final StringBuilder result = new StringBuilder();
        host.registerHandler("/myapp/myservice", new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                String name = (String)((Deque)exchange.getQueryParameters().get("name")).getFirst();
                result.append("Hello " + name);
            }
        });
        HttpRequest.HttpResponse response = HttpRequest.get((String)"http://localhost:8080/myapp/myservice?name=Kermit").getResponse();
        Assert.assertEquals((long)200L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"Hello Kermit", (Object)result.toString());
    }
}

