/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.zookeeper;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ExchangeBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.zookeeper.EmbeddedZookeeperServer;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class ZookeeperConsumerIntegrationTest {
    static EmbeddedZookeeperServer server;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"zookeeper-integration-tests");
        archive.addClasses(new Class[]{EmbeddedZookeeperServer.class});
        return archive;
    }

    @Before
    public void before() throws Exception {
        server = new EmbeddedZookeeperServer().startup(1, TimeUnit.SECONDS);
    }

    @After
    public void after() throws Exception {
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZookeeperConsumer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("zookeeper://" + server.getConnection() + "/somenode").to("direct:end");
            }
        });
        PollingConsumer pollingConsumer = camelctx.getEndpoint("direct:end").createPollingConsumer();
        pollingConsumer.start();
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            Exchange exchange = ExchangeBuilder.anExchange((CamelContext)camelctx).withBody((Object)"Kermit").build();
            producer.send("zookeeper://" + server.getConnection() + "/somenode?create=true", exchange);
            String result = (String)pollingConsumer.receive().getIn().getBody(String.class);
            Assert.assertEquals((Object)"Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

