/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.zookeeper;

import java.util.concurrent.TimeUnit;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.zookeeper.EmbeddedZookeeperServer;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class ZookeeperProducerIntegrationTest {
    static EmbeddedZookeeperServer server;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"zookeeper-integration-tests");
        archive.addClasses(new Class[]{EmbeddedZookeeperServer.class});
        return archive;
    }

    @Before
    public void before() throws Exception {
        server = new EmbeddedZookeeperServer().startup(1, TimeUnit.SECONDS);
    }

    @After
    public void after() throws Exception {
        if (server != null) {
            server.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZookeeperProducer() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("zookeeper://" + server.getConnection() + "/somenode?create=true");
            }
        });
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.assertEquals((Object)"/somenode", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

