/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cxf.ws;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ServiceStatus;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.types.Endpoint;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class CXFWSConsumerIntegrationTest {
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive deployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cxf-ws-consumer-tests");
        archive.addClasses(new Class[]{Endpoint.class});
        archive.addAsResource("cxf/spring/cxfws-consumer-camel-context.xml", "cxfws-consumer-camel-context.xml");
        return archive;
    }

    @Test
    public void testCXFConsumer() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("cxfws-undertow");
        Assert.assertNotNull((String)"Expected cxfws-undertow to not be null", (Object)camelctx);
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        QName qname = new QName("http://wildfly.camel.test.cxf", "EndpointService");
        Service service = Service.create((URL)new URL("http://localhost:8080/EndpointService/EndpointPort?wsdl"), (QName)qname);
        Endpoint endpoint = (Endpoint)service.getPort(Endpoint.class);
        Assert.assertNotNull((String)"Endpoint not null", (Object)endpoint);
        Assert.assertEquals((Object)"Hello Kermit", (Object)endpoint.echo("Kermit"));
    }

    @Test
    public void testCXFRoundtrip() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("cxfws-undertow");
        Assert.assertNotNull((String)"Expected cxfws-undertow to not be null", (Object)camelctx);
        Assert.assertEquals((Object)ServiceStatus.Started, (Object)camelctx.getStatus());
        ProducerTemplate producer = camelctx.createProducerTemplate();
        String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }
}

