/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.protobuf;

import com.google.protobuf.Message;
import java.io.ByteArrayOutputStream;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dataformat.protobuf.ProtobufDataFormat;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.DataFormat;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.protobuf.model.AddressBookProtos;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class ProtobufIntegrationTest {
    @Deployment
    public static JavaArchive createdeployment() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"protobuf-tests");
        archive.addClasses(new Class[]{AddressBookProtos.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshall() throws Exception {
        final ProtobufDataFormat format = new ProtobufDataFormat((Message)AddressBookProtos.Person.getDefaultInstance());
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").marshal((DataFormat)format);
            }
        });
        AddressBookProtos.Person person = AddressBookProtos.Person.newBuilder().setId(1).setName("John Doe").build();
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)person, String.class);
            Assert.assertEquals((Object)"John Doe", (Object)result.trim());
        }
        finally {
            camelctx.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmarshall() throws Exception {
        final ProtobufDataFormat format = new ProtobufDataFormat((Message)AddressBookProtos.Person.getDefaultInstance());
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").unmarshal((DataFormat)format);
            }
        });
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        AddressBookProtos.Person person = AddressBookProtos.Person.newBuilder().setId(1).setName("John Doe").build();
        person.writeTo(baos);
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            AddressBookProtos.Person result = (AddressBookProtos.Person)producer.requestBody("direct:start", (Object)baos.toByteArray(), AddressBookProtos.Person.class);
            Assert.assertEquals((Object)"John Doe", (Object)result.getName().trim());
        }
        finally {
            camelctx.stop();
        }
    }
}

