/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.swagger;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.common.http.HttpRequest;
import org.wildfly.camel.test.swagger.subA.User;
import org.wildfly.extension.camel.CamelAware;

@CamelAware
@RunWith(value=Arquillian.class)
public class SwaggerIntegrationTest {
    @Deployment
    public static WebArchive createDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"swagger-tests.war");
        archive.addClasses(new Class[]{HttpRequest.class, User.class});
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestDsl() throws Exception {
        DefaultCamelContext camelctx = new DefaultCamelContext();
        camelctx.setName("swagger-test");
        camelctx.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.restConfiguration().component("undertow").contextPath("swagger-tests/rest").host("localhost").port(8080).apiContextPath("/api-doc").apiProperty("api.title", "User API").apiProperty("api.version", "1.2.3").apiProperty("cors", "true");
                this.rest("/hello").get("/{name}").description("A user object").outType(User.class).to("direct:hello").produces("application/json").consumes("application/json");
                this.from("direct:hello").transform((Expression)this.simple("Hello ${header.name}"));
            }
        });
        camelctx.start();
        try {
            HttpRequest.HttpResponse result = HttpRequest.get((String)"http://localhost:8080/swagger-tests/rest/hello/Kermit").getResponse();
            Assert.assertEquals((Object)"Hello Kermit", (Object)result.getBody());
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            for (ObjectName oname : server.queryNames(new ObjectName("*:type=context,*"), null)) {
                Object jmxret = server.invoke(oname, "dumpRestsAsXml", null, null);
                System.out.println(oname + ": " + jmxret);
            }
            result = HttpRequest.get((String)"http://localhost:8080/swagger-tests/rest/api-doc").getResponse();
            Assert.assertEquals((long)200L, (long)result.getStatusCode());
            Assert.assertTrue((String)("Contains substr: " + result.getBody()), (boolean)result.getBody().contains("\"name\" : \"hello\""));
        }
        finally {
            camelctx.stop();
        }
    }
}

