/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.cdi;

import org.apache.camel.CamelContext;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.cdi.subB.HelloBean;
import org.wildfly.camel.test.cdi.subB.SimpleRouteBuilder;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.CamelContextRegistry;

@CamelAware
@RunWith(value=Arquillian.class)
public class CDIEarRouteBuilderIntegrationTest {
    private static final String SIMPLE_JAR = "camel-ejb-jar.jar";
    private static final String SIMPLE_EAR = "camel-ejb-ear.ear";
    @ArquillianResource
    CamelContextRegistry contextRegistry;

    @Deployment
    public static JavaArchive createdeployment() {
        return (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-ejb-ear-tests");
    }

    @Test
    public void testEjbJarDeployment() throws Exception {
        CamelContext camelctx = this.contextRegistry.getCamelContext("simple-camel-context");
        Assert.assertNotNull((Object)camelctx);
        String result = (String)camelctx.createProducerTemplate().requestBody("direct:start", (Object)"Kermit", String.class);
        Assert.assertEquals((Object)"Hello Kermit", (Object)result);
    }

    @Deployment(name="camel-ejb-ear.ear", managed=true, testable=false)
    public static EnterpriseArchive createEarDeployment() {
        return (EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)SIMPLE_EAR)).addAsModule(((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)SIMPLE_JAR)).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addClasses(new Class[]{SimpleRouteBuilder.class, HelloBean.class}));
    }
}

